/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于PC端Web显示壳NWJS操作接口
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.10.30
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_ui_lang */
/* exported mc_get_lang */


/* global Papa */
/* global $ */
/* global mc_ui_lang_error_code */

function mc_ui_lang(str_lang) {
    // 语言类型String
    var m_str_lang_id = str_lang;

    // 数据Object
    var m_map_lang_data = {};
    // 语言列表Array
    var m_ary_lang_ids = [];
    // 寄存器语言列表
    var m_register_lang_data = {};

    // 加载语言信息
    load_lang_file();

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    加载文件，将 m_map_lang_data、m_ary_lang_ids 数据更新
     * 参数:
     *    无
     * 返回：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    function load_lang_file() {
        // 再次初始化数据
        m_map_lang_data = {};
        m_ary_lang_ids = [];

        $.ajax({
            url: "/asset/language.csv",
            method: "get",
            async: false,
            success: function (str_get_txt) {
                // Papa.parse 解析CSV
                var obj_paser_data = Papa.parse(str_get_txt).data;

                if (null === obj_paser_data || 1 > obj_paser_data.length) {
                    return;
                }

                /* get language id array */
                m_ary_lang_ids = obj_paser_data[0];
                if (0 === m_ary_lang_ids.length) {
                    return;
                }
                // 去除首位ID
                m_ary_lang_ids.splice(0, 1);
                // 语言类型 没有则为第一个
                var ui_current_lang_idx = 0;
                // 若设置语言类型

                if ("string" === typeof m_str_lang_id && 0 < m_str_lang_id.length) {
                    var str_set_lang_id = m_str_lang_id.toUpperCase();

                    str_set_lang_id.trim();
                    // 循环语言列表 找出当前设置的语言类型
                    for (var idx_lang = 0; idx_lang < m_ary_lang_ids.length; idx_lang++) {
                        var str_lang_id = m_ary_lang_ids[idx_lang].toUpperCase();

                        str_lang_id.trim();
                        if (str_set_lang_id === str_lang_id) {
                            // 记录下标
                            ui_current_lang_idx = idx_lang;
                            break;
                        }
                    }
                }

                /* get item ids and values */
                ui_current_lang_idx++;
                for (var idx_row = 1; idx_row < obj_paser_data.length; idx_row++) {
                    if (1 > obj_paser_data[idx_row].length) {
                        continue;
                    }
                    var str_key = obj_paser_data[idx_row][0];

                    if (null === str_key) {
                        continue;
                    }
                    str_key.trim();
                    if (null === str_key || 0 === str_key.length) {
                        continue;
                    }

                    var str_val = "";

                    if (ui_current_lang_idx < obj_paser_data[idx_row].length) {
                        str_val = obj_paser_data[idx_row][ui_current_lang_idx];
                        str_val.trim();
                    }

                    m_map_lang_data[str_key.toUpperCase()] = str_val;
                }
            }
        });

        return;
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置语言类型
     * 参数:
     *    @param { Promise<String> } str_lang_id 语言类型，不能为空
     * 返回：
     *    @returns { Promise<Boolean> }
     *      true 设置成功 或 与上次设置的语言类型相同
     *      false 参数类型错误 或 参数名称为空
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_lang_id = function (str_lang_id) {
        if ("string" !== typeof str_lang_id || 0 === str_lang_id.length) {
            return false;
        }
        if (m_str_lang_id === str_lang_id) {
            return true;
        }

        m_str_lang_id = str_lang_id;
        load_lang_file();
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置寄存器语言列表
     * 参数:
     *    @param { Promise<Object> } obj_register_data 寄存器语言对象
     * 返回：
     *    @returns { Promise<Boolean> }
     *      true 设置成功
     *      false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.11.9
     *      内容 : 所有代码
     *   2. 类型 : 修改
     *      作者 : 巫昭雯
     *      时间 : 2021.3.5
     *      内容 : 寄存器新增语言改用push方式, 非直接赋值修改局部存储寄存器语言表对象
     ************************************************************************************************/
    this.set_register_data = function (obj_register_data) {
        if ("object" !== typeof obj_register_data) {
            return false;
        }

        var ary_key = Object.keys(obj_register_data);
        var ui_len = ary_key.length;

        for (var idx = 0; idx < ui_len; idx++) {
            var str_item = ary_key[idx];

            m_register_lang_data[str_item] = obj_register_data[str_item];
        }

        // m_register_lang_data = obj_register_data;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取当前语言类型
     * 参数:
     *    NA
     * 返回：
     *    @returns { Promise<String> }
     *      true 设置成功 或 与上次设置的语言类型相同
     *      false 参数类型错误 或 参数名称为空
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_lang_id = function () {
        return m_str_lang_id;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取语言列表
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<Array> }
     *      语言列表
     *      null 未设置文件路径
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_lang_ary = function () {
        if (0 === m_ary_lang_ids.length) {
            return null;
        }
        return m_ary_lang_ids;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    按参数索引（ID名称），取得对应语言的值
     * 参数:
     *    @param { Promise<String> } str_item_id 参数索引，不能为空
     * 返回：
     *    @return { Promise<String> }
     *      对应语言的值字串
     *      null 参数类型错误 或 名称不存在
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_item_val = function (str_item_id) {
        if ("string" !== typeof str_item_id || 0 === str_item_id.length) {
            return str_item_id;
        }
        var lang_id_val = str_item_id.toUpperCase();

        lang_id_val.trim();

        //判断VAL是否为空
        var item_val = m_map_lang_data[lang_id_val];

        if ("undefined" === typeof item_val) {
            return str_item_id;
        }
        return item_val;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    按照索引，取得ID名称
     * 参数:
     *    @param { Promise<Number> } ui_idx 参数索引，不能为空
     * 返回：
     *    @return { Promise<String> } ID名称
     *    false 参数索引类型错误 或 为空
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_item_id = function (ui_idx) {
        if ("number" !== typeof ui_idx || 0 === ui_idx.length) {
            return false;
        }
        // key数组前几位是封装的map方法
        return Object.keys(m_map_lang_data)[ui_idx + 4];
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取语言表
     * 参数:
     *    NA
     * 返回：
     *    @return { Promise<object> } KEY=ID, VALUE=lang
     *    false 参数索引类型错误 或 为空
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_item_map = function () {
        var ary_register_lang_key = Object.keys(m_register_lang_data);

        // 添加寄存器语言
        for (var idx = 0; idx < ary_register_lang_key.length; idx++) {
            var str_key = ary_register_lang_key[idx];
            var str_val = m_register_lang_data[str_key];

            m_map_lang_data[str_key.toUpperCase()] = str_val;
        }
        return m_map_lang_data;
    };
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取顶层语言对象及语言列表
 * 参数:
 *    NA
 * 返回：
 *    @return { Promise<object> }
 *     lang_params {g_obj_lang, obj_lang_map}
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.7.15
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_lang() {
    // 语言对象
    var g_obj_lang = null;
    // 语言列表
    var obj_lang_map = null;
    var g_str_lang = "";
    var parent_page = parent;

    while (parent_page) {
        g_obj_lang = parent_page.g_obj_lang;
        if (parent_page.g_obj_lang) {
            g_obj_lang = parent_page.g_obj_lang;
            obj_lang_map = parent_page.obj_lang_map;
            break;
        } else if (parent_page !== parent_page.parent) {
            parent_page = parent_page.parent;
        } else {
            break;
        }
    }

    if (!g_obj_lang) {
        g_obj_lang = new mc_ui_lang(g_str_lang);
        obj_lang_map = g_obj_lang.get_item_map();
    }

    var o_err = mc_lang_err_get();
    var lang_params = {
        g_obj_lang: g_obj_lang,
        obj_lang_map: obj_lang_map,
        // error code
        g_obj_lang_error_code: o_err.obj,
        g_obj_error_code_map: o_err.data
    };

    return lang_params;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取index.html错误码
 * 参数:
 *    NA
 * 返回:
 *    @returns { Promise<Object> } { obj:错误码构造函数对象, data:当前语言错误码map}
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-07-17
 *       内容 : 所有代码
************************************************************************************************/
function mc_lang_err_get() {
    // error code
    var obj_lang_error_code = {};
    var obj_error_code_map = {};
    // get error code
    var parent_page = parent;

    while (parent_page) {
        obj_lang_error_code = parent_page.g_obj_lang_error_code;
        if (obj_lang_error_code) {
            obj_error_code_map = parent_page.g_obj_error_code_map;
            break;
        }

        if (parent_page !== parent_page.parent) {
            parent_page = parent_page.parent;
        } else {
            break;
        }
    }

    if (!obj_lang_error_code) {
        obj_lang_error_code = new mc_ui_lang_error_code();
        obj_lang_error_code.set_lang_type(parent_page.g_str_lang);
        obj_error_code_map = obj_lang_error_code.get_map();
    }

    return {
        obj: obj_lang_error_code,
        data: obj_error_code_map
    };
}

